export interface SMTPConfig {
  host: string;
  port: number;
  secure: boolean;
  auth: {
    user: string;
    pass: string;
  };
  tls?: {
    rejectUnauthorized?: boolean;
  };
}

export interface IMAPConfig {
  host: string;
  port: number;
  secure: boolean;
  auth: {
    user: string;
    pass: string;
  };
  tls?: {
    rejectUnauthorized?: boolean;
  };
}

export interface MailSettings {
  id: string;
  name: string;
  smtp: SMTPConfig;
  imap: IMAPConfig;
  defaultFrom: string;
  defaultFromName: string;
  isDefault: boolean;
  isActive: boolean;
  createdAt: Date;
  updatedAt: Date;
}

export interface EmailTemplate {
  id: string;
  name: string;
  subject: string;
  htmlContent: string;
  textContent: string;
  variables: string[];
  category: EmailTemplateCategory;
  isActive: boolean;
  createdAt: Date;
  updatedAt: Date;
}

export type EmailTemplateCategory = 
  | 'employee_welcome'
  | 'leave_approval'
  | 'leave_rejection'
  | 'payroll_slip'
  | 'attendance_reminder'
  | 'birthday_wishes'
  | 'general';

export interface EmailMessage {
  to: string | string[];
  cc?: string | string[];
  bcc?: string | string[];
  subject: string;
  html?: string;
  text?: string;
  attachments?: EmailAttachment[];
  templateId?: string;
  templateVariables?: Record<string, any>;
}

export interface EmailAttachment {
  filename: string;
  content: Buffer | string;
  contentType?: string;
  cid?: string;
}

export interface SentEmail {
  id: string;
  messageId: string;
  to: string[];
  cc?: string[];
  bcc?: string[];
  subject: string;
  status: EmailStatus;
  sentAt: Date;
  deliveredAt?: Date;
  openedAt?: Date;
  error?: string;
  templateId?: string;
  attachments?: string[];
}

export interface ReceivedEmail {
  id: string;
  messageId: string;
  from: string;
  to: string[];
  cc?: string[];
  subject: string;
  html?: string;
  text?: string;
  receivedAt: Date;
  isRead: boolean;
  attachments?: EmailAttachment[];
  inReplyTo?: string;
  references?: string[];
}

export type EmailStatus = 
  | 'pending'
  | 'sent'
  | 'delivered'
  | 'failed'
  | 'bounced'
  | 'opened';

export interface EmailQueue {
  id: string;
  message: EmailMessage;
  status: EmailStatus;
  attempts: number;
  maxAttempts: number;
  scheduledAt?: Date;
  processedAt?: Date;
  error?: string;
  createdAt: Date;
  updatedAt: Date;
}

export interface MailServiceResponse<T = any> {
  success: boolean;
  data?: T;
  error?: string;
  message?: string;
}

export interface TestConnectionRequest {
  smtp?: SMTPConfig;
  imap?: IMAPConfig;
}

export interface TestConnectionResponse {
  smtpStatus: boolean;
  imapStatus: boolean;
  errors?: {
    smtp?: string;
    imap?: string;
  };
}