// Service types exports
export * from './employeeService.types';
export * from './departmentService.types';
export * from './attendanceService.types';
export * from './leaveService.types';
export * from './payrollService.types';
export * from './userService.types';
export * from './reportsService.types';
export * from './notificationService.types';
export * from './dashboardService.types';
export * from './mailService.types';
export * from './holidayService.types';
export * from './complianceService.types';

// Common service response types
export interface ServiceResponse<T> {
  success: boolean;
  data?: T;
  error?: string;
  message?: string;
  metadata?: {
    total?: number;
    page?: number;
    limit?: number;
    timestamp: string;
    requestId?: string;
  };
}

export interface PaginatedResponse<T> {
  data: T[];
  pagination: {
    total: number;
    page: number;
    limit: number;
    totalPages: number;
    hasNext: boolean;
    hasPrevious: boolean;
  };
}

export interface BulkOperationResponse {
  success: boolean;
  processedCount: number;
  failedCount: number;
  errors?: Array<{
    id: string;
    error: string;
  }>;
}

export interface ServiceValidationError {
  field: string;
  message: string;
  code?: string;
}

export interface ServiceApiError {
  code: string;
  message: string;
  details?: any;
  timestamp: string;
  path?: string;
}

// Common filter and sort types
export interface BaseFilter {
  search?: string;
  limit?: number;
  offset?: number;
  sortBy?: string;
  sortOrder?: 'asc' | 'desc';
}

export interface DateRangeFilter {
  startDate: string;
  endDate: string;
}

export interface NumericRangeFilter {
  min: number;
  max: number;
}

// Service configuration types
export interface ServiceConfig {
  baseUrl: string;
  timeout: number;
  retryAttempts: number;
  enableLogging: boolean;
  apiKey?: string;
}

// Audit trail types
export interface AuditLog {
  id: string;
  entityType: string;
  entityId: string;
  action: 'created' | 'updated' | 'deleted' | 'viewed' | 'exported';
  userId: string;
  userName: string;
  timestamp: string;
  changes?: Array<{
    field: string;
    oldValue: any;
    newValue: any;
  }>;
  metadata?: Record<string, any>;
}

// Cache types
export interface CacheConfig {
  ttl: number; // Time to live in seconds
  key: string;
  tags?: string[];
}

export interface CachedResponse<T> {
  data: T;
  cachedAt: string;
  expiresAt: string;
  isStale: boolean;
}