import React from 'react';
import {
  Backdrop,
  CircularProgress,
  Typography,
  Box,
} from '@mui/material';

interface LoaderOverlayProps {
  open: boolean;
  message?: string;
  size?: number;
}

export const LoaderOverlay: React.FC<LoaderOverlayProps> = ({
  open,
  message = 'Loading...',
  size = 60,
}) => {
  return (
    <Backdrop
      sx={{
        color: '#fff',
        zIndex: (theme) => theme.zIndex.drawer + 1,
        backdropFilter: 'blur(4px)',
        backgroundColor: 'rgba(0, 0, 0, 0.3)',
      }}
      open={open}
    >
      <Box
        sx={{
          display: 'flex',
          flexDirection: 'column',
          alignItems: 'center',
          gap: 2,
        }}
      >
        <CircularProgress color="primary" size={size} />
        {message && (
          <Typography variant="h6" color="inherit">
            {message}
          </Typography>
        )}
      </Box>
    </Backdrop>
  );
};