export interface JobPosting {
  id: string;
  title: string;
  department: string;
  location: string;
  employmentType: 'Full-time' | 'Part-time' | 'Contract' | 'Temporary' | 'Internship';
  experienceLevel: 'Entry Level' | 'Mid Level' | 'Senior Level' | 'Executive';
  salaryRange: {
    min: number;
    max: number;
    currency: string;
  };
  description: string;
  requirements: string[];
  responsibilities: string[];
  benefits: string[];
  postedDate: string;
  applicationDeadline: string;
  status: 'Draft' | 'Published' | 'Closed' | 'On Hold';
  hiringManager: string;
  applicationCount: number;
  createdBy: string;
  updatedAt: string;
}

export interface Candidate {
  id: string;
  firstName: string;
  lastName: string;
  email: string;
  phone: string;
  address: string;
  resumeUrl?: string;
  coverLetterUrl?: string;
  linkedInProfile?: string;
  portfolioUrl?: string;
  currentPosition?: string;
  currentCompany?: string;
  totalExperience: number;
  expectedSalary?: number;
  noticePeriod?: string;
  skills: string[];
  education: Education[];
  workExperience: WorkExperience[];
  appliedJobs: ApplicationHistory[];
  status: 'New' | 'Reviewed' | 'Shortlisted' | 'Interviewed' | 'Offered' | 'Hired' | 'Rejected';
  source: 'Website' | 'LinkedIn' | 'Referral' | 'Job Board' | 'Agency' | 'Direct';
  notes: string;
  createdAt: string;
  updatedAt: string;
}

export interface Education {
  id: string;
  degree: string;
  institution: string;
  fieldOfStudy: string;
  startDate: string;
  endDate: string;
  grade?: string;
  description?: string;
}

export interface WorkExperience {
  id: string;
  jobTitle: string;
  company: string;
  location: string;
  startDate: string;
  endDate?: string;
  isCurrentJob: boolean;
  description: string;
  achievements: string[];
}

export interface ApplicationHistory {
  id: string;
  jobId: string;
  jobTitle: string;
  appliedDate: string;
  status: 'Applied' | 'Under Review' | 'Shortlisted' | 'Interview Scheduled' | 'Interviewed' | 'Offered' | 'Hired' | 'Rejected' | 'Withdrawn';
  stage: string;
  feedback?: string;
  interviewHistory: Interview[];
}

export interface Interview {
  id: string;
  candidateId: string;
  jobId: string;
  type: 'Phone' | 'Video' | 'In-Person' | 'Technical' | 'HR' | 'Final';
  round: number;
  scheduledDate: string;
  duration: number;
  location?: string;
  meetingLink?: string;
  interviewers: Interviewer[];
  status: 'Scheduled' | 'Completed' | 'Cancelled' | 'Rescheduled' | 'No Show';
  feedback?: InterviewFeedback;
  createdBy: string;
  createdAt: string;
  updatedAt: string;
}

export interface Interviewer {
  id: string;
  name: string;
  email: string;
  role: string;
  department: string;
  isLead: boolean;
}

export interface InterviewFeedback {
  id: string;
  interviewId: string;
  interviewerId: string;
  overallRating: 1 | 2 | 3 | 4 | 5;
  technicalSkills?: 1 | 2 | 3 | 4 | 5;
  communicationSkills?: 1 | 2 | 3 | 4 | 5;
  problemSolving?: 1 | 2 | 3 | 4 | 5;
  culturalFit?: 1 | 2 | 3 | 4 | 5;
  strengths: string[];
  areasForImprovement: string[];
  comments: string;
  recommendation: 'Strong Hire' | 'Hire' | 'No Hire' | 'Strong No Hire';
  submittedAt: string;
}

export interface OfferLetter {
  id: string;
  candidateId: string;
  jobId: string;
  position: string;
  department: string;
  startDate: string;
  salary: number;
  currency: string;
  benefits: string[];
  workLocation: string;
  reportingManager: string;
  probationPeriod: number;
  noticePeriod: number;
  offerValidUntil: string;
  terms: string;
  status: 'Draft' | 'Sent' | 'Accepted' | 'Declined' | 'Negotiating' | 'Expired';
  sentDate?: string;
  responseDate?: string;
  negotiationNotes?: string;
  createdBy: string;
  approvedBy?: string;
  createdAt: string;
  updatedAt: string;
}

export interface OnboardingTask {
  id: string;
  title: string;
  description: string;
  category: 'Documentation' | 'IT Setup' | 'Training' | 'Orientation' | 'Legal' | 'Benefits';
  assignedTo: 'HR' | 'Manager' | 'IT' | 'Employee' | 'Finance';
  dueDate: string;
  priority: 'Low' | 'Medium' | 'High' | 'Critical';
  status: 'Pending' | 'In Progress' | 'Completed' | 'Blocked';
  completedDate?: string;
  completedBy?: string;
  notes?: string;
  attachments?: string[];
}

export interface OnboardingProcess {
  id: string;
  employeeId: string;
  candidateId: string;
  startDate: string;
  department: string;
  position: string;
  reportingManager: string;
  buddy?: string;
  status: 'Not Started' | 'In Progress' | 'Completed' | 'On Hold';
  progress: number;
  tasks: OnboardingTask[];
  welcomePackSent: boolean;
  workstationAssigned: boolean;
  accountsCreated: boolean;
  trainingScheduled: boolean;
  firstDayCompleted: boolean;
  firstWeekCompleted: boolean;
  probationReviewScheduled: boolean;
  feedback?: string;
  createdAt: string;
  updatedAt: string;
}

export interface RecruitmentMetrics {
  totalJobPostings: number;
  activeJobPostings: number;
  totalApplications: number;
  newApplicationsToday: number;
  interviewsScheduled: number;
  offersExtended: number;
  hiresCompleted: number;
  averageTimeToHire: number;
  averageCostPerHire: number;
  applicationToInterviewRate: number;
  interviewToOfferRate: number;
  offerAcceptanceRate: number;
  sourceEffectiveness: Record<string, number>;
}

export interface RecruitmentFilters {
  department?: string;
  location?: string;
  employmentType?: string;
  experienceLevel?: string;
  status?: string;
  source?: string;
  dateRange?: {
    start: string;
    end: string;
  };
}

export interface JobPostingRequest {
  title: string;
  department: string;
  location: string;
  employmentType: 'Full-time' | 'Part-time' | 'Contract' | 'Temporary' | 'Internship';
  experienceLevel: 'Entry Level' | 'Mid Level' | 'Senior Level' | 'Executive';
  salaryRange: {
    min: number;
    max: number;
    currency: string;
  };
  description: string;
  requirements: string[];
  responsibilities: string[];
  benefits: string[];
  applicationDeadline: string;
  hiringManager: string;
}

export interface CandidateRequest {
  firstName: string;
  lastName: string;
  email: string;
  phone: string;
  address: string;
  resumeFile?: File;
  coverLetterFile?: File;
  linkedInProfile?: string;
  portfolioUrl?: string;
  currentPosition?: string;
  currentCompany?: string;
  totalExperience: number;
  expectedSalary?: number;
  noticePeriod?: string;
  skills: string[];
  jobId?: string;
  source: string;
}

export interface InterviewRequest {
  candidateId: string;
  jobId: string;
  type: 'Phone' | 'Video' | 'In-Person' | 'Technical' | 'HR' | 'Final';
  round: number;
  scheduledDate: string;
  duration: number;
  location?: string;
  meetingLink?: string;
  interviewerIds: string[];
}

export interface OnboardingProcessRequest {
  employeeId: string;
  candidateId: string;
  startDate: string;
  department: string;
  position: string;
  reportingManager: string;
  buddy?: string;
  customTasks?: Omit<OnboardingTask, 'id'>[];
}